// $Id: CTextLabel.cpp,v 1.7 2007/02/27 19:47:11 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CTextLabel.hpp"
using Exponent::GUI::Controls::CTextLabel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTextLabel, CControl);

//	===========================================================================
CTextLabel::CTextLabel(IControlRoot *root, const long uniqueId, const CRect &area, const CString &text) 
		  : CControl(root, uniqueId, area)
		  , m_drawFrameAndBackground(true)
		  , m_font(NULL)
		  , m_textColour(CAlphaColour::CALPHACOLOUR_BLACK)
		  , m_text(text)
		  , m_textFormat(CGraphics::e_defaultLabelText)
{
	EXPONENT_CLASS_CONSTRUCTION(CTextLabel);
	this->controlIsMouseEnabled(false);
	this->controlIsDropFileEnabled(true);
	EXCHANGE_COUNTED_OBJECTS(m_font, CFont::CFONT_SYSTEM_FONT);
	this->update();
}

//	===========================================================================
CTextLabel::~CTextLabel()
{
	EXPONENT_CLASS_DESTRUCTION(CTextLabel);
	FORGET_COUNTED_OBJECT(m_font);
}

//	===========================================================================
void CTextLabel::setColours(const CAlphaColour &frameColour, const CAlphaColour &backgroundColour, const CAlphaColour &textColour)
{
	m_frameColour	   = frameColour;
	m_backgroundColour = backgroundColour;
	m_textColour	   = textColour;
}

//	===========================================================================
void CTextLabel::setTextColour(const CAlphaColour &textColour)
{
	this->setColours(m_frameColour, m_backgroundColour, textColour);
}

//	===========================================================================
void CTextLabel::setFont(CFont *font)
{
	//m_font = font;
	EXCHANGE_COUNTED_OBJECTS(m_font, font);
}

//	===========================================================================
void CTextLabel::setText(const CString &text)
{
	m_text = text;
	this->update();
}

//	===========================================================================
void CTextLabel::setTextFormat(const CGraphics::ETextAlignment format)
{
	m_textFormat = format;
}

//	===========================================================================
void CTextLabel::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the background
	this->drawPrimaryImage(graphics, m_doDefaultDrawing);

	// Draw the text string out
	graphics.setTextColour(m_textColour);
	graphics.drawText(m_text, CRect(1, 1, m_area.getWidth(), m_area.getHeight()), m_font, m_textFormat);
}

//	===========================================================================
void CTextLabel::handleFileDrop(const CDropEvent &event)
{
	// Get the strings
	TStringCountedPointerArray *array = event.getDroppedFileNames();

	// Check its valid
	if (array == NULL)
	{
		return;
	}

	CString *string = array->elementAtIndex(0);

	if (string)
	{
		this->setText(*string);
		this->update();
	}
}
